//
//  PXICustomScroller.h
//  PXIView
//
//  Created by decaf on 11/23/04.
//  Copyright 2004 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface PXICustomScroller : NSControl {

	float scale;
	float myFloatValue;
	NSScrollerPart myHitPart;
	
	NSImage * myScrollPat;
	NSImage * uparrow;
	NSImage * huparrow;
	NSImage * downarrow;
	NSImage * hdownarrow;
	
	BOOL downArrowOn;
	BOOL upArrowOn;
	
	id myTarget;
	SEL myAction;
	int myTag;
	
}

- (float)scale;
- (void)setScale:(float)newScale;
- (float)myFloatValue;
- (void)setMyFloatValue:(float)newMyFloatValue;

+ (float)scrollerWidth;
+ (float)scrollerWidthForControlSize:(NSControlSize)controlSize;

- (NSScrollArrowPosition)arrowsPosition;
- (void)checkSpaceForParts;
- (NSControlSize)controlSize;
- (NSControlTint)controlTint;
- (void)drawArrow:(NSScrollerArrow)arrow highlight:(BOOL)flag;
- (void)drawKnob;
- (void)drawParts;
- (void)highlight:(BOOL)flag;
- (NSScrollerPart)hitPart;
- (float)knobProportion;
- (NSRect)rectForPart:(NSScrollerPart)aPart;
- (void)setArrowsPosition:(NSScrollArrowPosition)location;
- (void)setControlSize:(NSControlSize)controlSize;
- (void)setControlTint:(NSControlTint)controlTint;
- (void)setFloatValue:(float)aFloat knobProportion:(float)knobProp;
- (NSScrollerPart)testPart:(NSPoint)aPoint;
- (void)trackKnob:(NSEvent *)theEvent;
- (void)trackScrollButtons:(NSEvent *)theEvent;
- (NSUsableScrollerParts)usableParts;

@end
